/**
* \file: NaviStatus.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: Ajay Kumar Sahoo/ RBEI/ECF3 / ajaykumar.sahoo@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <string>

#include "NaviStatus.h"
#include "NaviStatusImpl.h"

LOG_IMPORT_CONTEXT(navi_status)

namespace adit { namespace aauto {
using std::string;

NaviStatus::NaviStatus(uint8_t inSessionId, MessageRouter* inMessageRouter, int inMinIntervalMs, int inheight, int inWidth,
                       int inColorDepthBits, NavigationStatusService_InstrumentClusterType inType):
                          AditNavigationStatus(inSessionId, inMessageRouter, inMinIntervalMs, inheight, inWidth,
                                                  inColorDepthBits,inType)
{
    impl = new NaviStatusImpl(this, (void*) inMessageRouter);
}

NaviStatus::~NaviStatus()
{
    /* impl id deleted at GalReceiver destruction,
     * it is registered as a callback and hold in a shared pointer */
}

void NaviStatus::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

void NaviStatus::registerCallbacks(IAditNavigationStatusCallbacks* inCallbacks)
{
    impl->registerCallbacks(inCallbacks);
}

bool NaviStatus::init()
{
    LOG_INFO((navi_status, "test navigation status initialize"));
    return impl->init();
}

void NaviStatus::shutdown()
{
    LOG_INFO((navi_status, "test navigation status shut down"));
    impl->shutdown();
}

} } /* namespace adit { namespace aauto { */

